using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Margaret Jablonski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>06/02/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary></summary>
	public class FrmOrderSpecimenReflex : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private const string FORM_NAME = "Order Reflex Test(s)";
		private BOL.Specimen _specimen;
		private DataTable _dtTestList;
		private DataTable _dtRepeatXMUnitList;
		private bool _unitsVisible = false; //Used to determine if Units for Repeat Crossmatch are visible
		private Guid _orderedTestGUID;
		private int _orderableTestID;
		private Guid _patientSpecimenGUID;
		private Guid _patientTreatmentGUID;
		private Guid _orderedComponentGUID;
		private ArrayList _orderedTestsList; //Holds data passed from UC_56
		private ArrayList _orderedComponentsList; //Holds data passed from UC_56
		private string _expiredSpecimenComment = "";
		
		#endregion

		#region Form Controls
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.PatientOrderSelector patientOrderSelector1;
		private System.Windows.Forms.Panel pnlSelectSpecimen;
		private System.Windows.Forms.Panel pnlOrderReflex;
		private System.Windows.Forms.GroupBox grpReflex;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.ListView lvReflexTests;
		private gov.va.med.vbecs.GUI.controls.PatientSpecimenDisplayPanel patientSpecimenDisplayPanel1;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ListView lvCrossmatchUnits;
		private System.Windows.Forms.GroupBox grpUnits;
		private System.Windows.Forms.Panel pnlReflexUnits;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Constructors\Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmOrderSpecimenReflex()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();

			this.pnlSelectSpecimen.BringToFront();

			//Set UnexpiredOnlySpecimen property so only unexpired specimens are displayed
			this.patientOrderSelector1.UnexpiredOnlySpecimen = true;

			//Set Panels visibility property
			this.pnlSelectSpecimen.Visible = true;
			this.pnlOrderReflex.Visible = false;
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedTests"></param>
		/// <param name="orderedComponents"></param>
		/// <param name="cancelForm"></param>
		public FrmOrderSpecimenReflex(ArrayList orderedTests, ArrayList orderedComponents, ref bool cancelForm)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();

			this.pnlOrderReflex.BringToFront();

			//Set Panels visibility property
			this.pnlSelectSpecimen.Visible = false;
			this.pnlOrderReflex.Visible = true;
		
			//Get data from constructor parms and set local varibales
			this._orderedTestsList = orderedTests;
			this._orderedComponentsList = orderedComponents;
		
			if (DisplayMultipleOrders())
			{
				this._specimen = new BOL.Specimen(this._patientSpecimenGUID);
				this.PopulateOrderReflexPanel();
				cancelForm = false;
			}
			else
			{
				cancelForm = true;
			}
		}

		/// <summary>
		/// Dispose
		/// </summary>
		/// <param name="disposing"></param>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.Windows.Forms.ListViewItem listViewItem1 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "ABORh",
            "Repeat ABO/Rh"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem2 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "ABS",
            "Repeat Antibody Screen"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem3 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "DAT",
            "Repeat Direct Antiglobulin Test"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem4 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "XM",
            "Repeat Serologic Crossmatch"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem5 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "ABID",
            "Antibody ID"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem6 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "DAT Comp",
            "Direct Antiglobulin Test Complement"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem7 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "DAT IgG",
            "Direct Antiglobulin Test IgG"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem8 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "WeakD",
            "Patient Weak D"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem9 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "AGC",
            "C Antigen Typing"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem10 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "AGCe",
            "Ce Antigen Typing"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmOrderSpecimenReflex));
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.patientOrderSelector1 = new gov.va.med.vbecs.GUI.controls.PatientOrderSelector();
            this.pnlSelectSpecimen = new System.Windows.Forms.Panel();
            this.pnlOrderReflex = new System.Windows.Forms.Panel();
            this.pnlReflexUnits = new System.Windows.Forms.Panel();
            this.grpReflex = new System.Windows.Forms.GroupBox();
            this.lvReflexTests = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader8 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpUnits = new System.Windows.Forms.GroupBox();
            this.lvCrossmatchUnits = new System.Windows.Forms.ListView();
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader7 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.patientSpecimenDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientSpecimenDisplayPanel();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlSelectSpecimen.SuspendLayout();
            this.pnlOrderReflex.SuspendLayout();
            this.pnlReflexUnits.SuspendLayout();
            this.grpReflex.SuspendLayout();
            this.grpUnits.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(652, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Order Reflex Test(s)";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 442);
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(572, 431);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(492, 431);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 1;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // patientOrderSelector1
            // 
            this.patientOrderSelector1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientOrderSelector1.EnabledBloodAvailButton = false;
            this.patientOrderSelector1.EnabledMedicationButton = false;
            this.patientOrderSelector1.EnabledRecentOrdersButton = false;
            this.patientOrderSelector1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientOrderSelector1.EnabledSIAndTRButton = false;
            this.patientOrderSelector1.EnabledTransfusionReactionHistoryButton = false;
            this.patientOrderSelector1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientOrderSelector1.Location = new System.Drawing.Point(4, 0);
            this.patientOrderSelector1.Name = "patientOrderSelector1";
            this.patientOrderSelector1.OrderableTestId = 0;
            this.patientOrderSelector1.OrderedComponentGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
            this.patientOrderSelector1.OrderedTestGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
            this.patientOrderSelector1.OrderStatusCode = gov.va.med.vbecs.Common.OrderStatus.Accepted;
            this.patientOrderSelector1.PatientOrderGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
            this.patientOrderSelector1.PatientTreatmentGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
            this.patientOrderSelector1.Size = new System.Drawing.Size(644, 395);
            this.patientOrderSelector1.Specimen = null;
            this.patientOrderSelector1.TabIndex = 0;
            this.patientOrderSelector1.UnexpiredOnlySpecimen = false;
            this.patientOrderSelector1.ItemSelected += new System.EventHandler(this.patientOrderSelector1_ItemSelected);
            this.patientOrderSelector1.ItemDeselected += new System.EventHandler(this.patientOrderSelector1_ItemDeselected);
            // 
            // pnlSelectSpecimen
            // 
            this.pnlSelectSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlSelectSpecimen.Controls.Add(this.patientOrderSelector1);
            this.pnlSelectSpecimen.Location = new System.Drawing.Point(0, 32);
            this.pnlSelectSpecimen.Name = "pnlSelectSpecimen";
            this.pnlSelectSpecimen.Size = new System.Drawing.Size(652, 395);
            this.pnlSelectSpecimen.TabIndex = 0;
            // 
            // pnlOrderReflex
            // 
            this.pnlOrderReflex.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlOrderReflex.Controls.Add(this.pnlReflexUnits);
            this.pnlOrderReflex.Controls.Add(this.patientSpecimenDisplayPanel1);
            this.pnlOrderReflex.Controls.Add(this.grpImage);
            this.pnlOrderReflex.Location = new System.Drawing.Point(0, 32);
            this.pnlOrderReflex.Name = "pnlOrderReflex";
            this.pnlOrderReflex.Size = new System.Drawing.Size(652, 395);
            this.pnlOrderReflex.TabIndex = 3;
            // 
            // pnlReflexUnits
            // 
            this.pnlReflexUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlReflexUnits.Controls.Add(this.grpReflex);
            this.pnlReflexUnits.Controls.Add(this.grpUnits);
            this.pnlReflexUnits.Location = new System.Drawing.Point(48, 64);
            this.pnlReflexUnits.Name = "pnlReflexUnits";
            this.pnlReflexUnits.Size = new System.Drawing.Size(600, 331);
            this.pnlReflexUnits.TabIndex = 10;
            // 
            // grpReflex
            // 
            this.grpReflex.Controls.Add(this.lvReflexTests);
            this.grpReflex.Dock = System.Windows.Forms.DockStyle.Fill;
            this.grpReflex.Location = new System.Drawing.Point(0, 0);
            this.grpReflex.Name = "grpReflex";
            this.grpReflex.Size = new System.Drawing.Size(600, 215);
            this.grpReflex.TabIndex = 0;
            this.grpReflex.TabStop = false;
            this.grpReflex.Text = "Order Reflex Test(s)";
            // 
            // lvReflexTests
            // 
            this.lvReflexTests.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvReflexTests.CheckBoxes = true;
            this.lvReflexTests.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader8});
            this.lvReflexTests.FullRowSelect = true;
            listViewItem1.StateImageIndex = 0;
            listViewItem2.StateImageIndex = 0;
            listViewItem3.StateImageIndex = 0;
            listViewItem4.StateImageIndex = 0;
            listViewItem5.StateImageIndex = 0;
            listViewItem6.StateImageIndex = 0;
            listViewItem7.StateImageIndex = 0;
            listViewItem8.StateImageIndex = 0;
            listViewItem9.StateImageIndex = 0;
            listViewItem10.StateImageIndex = 0;
            this.lvReflexTests.Items.AddRange(new System.Windows.Forms.ListViewItem[] {
            listViewItem1,
            listViewItem2,
            listViewItem3,
            listViewItem4,
            listViewItem5,
            listViewItem6,
            listViewItem7,
            listViewItem8,
            listViewItem9,
            listViewItem10});
            this.lvReflexTests.Location = new System.Drawing.Point(8, 16);
            this.lvReflexTests.MultiSelect = false;
            this.lvReflexTests.Name = "lvReflexTests";
            this.lvReflexTests.Size = new System.Drawing.Size(584, 191);
            this.lvReflexTests.TabIndex = 0;
            this.lvReflexTests.UseCompatibleStateImageBehavior = false;
            this.lvReflexTests.View = System.Windows.Forms.View.Details;
            this.lvReflexTests.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvReflexTests_ItemCheck);
            this.lvReflexTests.SelectedIndexChanged += new System.EventHandler(this.lvReflexTests_SelectedIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Order";
            this.columnHeader1.Width = 40;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Test Code";
            this.columnHeader2.Width = 70;
            // 
            // columnHeader8
            // 
            this.columnHeader8.Text = "Reflex Test Name";
            this.columnHeader8.Width = 450;
            // 
            // grpUnits
            // 
            this.grpUnits.Controls.Add(this.lvCrossmatchUnits);
            this.grpUnits.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.grpUnits.Location = new System.Drawing.Point(0, 215);
            this.grpUnits.Name = "grpUnits";
            this.grpUnits.Size = new System.Drawing.Size(600, 116);
            this.grpUnits.TabIndex = 1;
            this.grpUnits.TabStop = false;
            this.grpUnits.Text = "Select Units for Repeat Crossmatch";
            this.grpUnits.Visible = false;
            // 
            // lvCrossmatchUnits
            // 
            this.lvCrossmatchUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvCrossmatchUnits.CheckBoxes = true;
            this.lvCrossmatchUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5,
            this.columnHeader6,
            this.columnHeader7});
            this.lvCrossmatchUnits.FullRowSelect = true;
            this.lvCrossmatchUnits.Location = new System.Drawing.Point(8, 16);
            this.lvCrossmatchUnits.MultiSelect = false;
            this.lvCrossmatchUnits.Name = "lvCrossmatchUnits";
            this.lvCrossmatchUnits.Size = new System.Drawing.Size(584, 92);
            this.lvCrossmatchUnits.TabIndex = 0;
            this.lvCrossmatchUnits.UseCompatibleStateImageBehavior = false;
            this.lvCrossmatchUnits.View = System.Windows.Forms.View.Details;
            this.lvCrossmatchUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvCrossmatchUnits_ItemCheck);
            this.lvCrossmatchUnits.SelectedIndexChanged += new System.EventHandler(this.lvCrossmatchUnits_SelectedIndexChanged);
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Select";
            this.columnHeader3.Width = 45;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "Unit ID";
            this.columnHeader4.Width = 120;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Product Name";
            this.columnHeader5.Width = 120;
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "ABO/Rh";
            this.columnHeader6.Width = 120;
            // 
            // columnHeader7
            // 
            this.columnHeader7.Text = "Expiration Date";
            this.columnHeader7.Width = 120;
            // 
            // patientSpecimenDisplayPanel1
            // 
            this.patientSpecimenDisplayPanel1.AboRh = "";
            this.patientSpecimenDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSpecimenDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientSpecimenDisplayPanel1.EnabledMedicationButton = false;
            this.patientSpecimenDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientSpecimenDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSpecimenDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientSpecimenDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSpecimenDisplayPanel1.Expires = "";
            this.patientSpecimenDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientSpecimenDisplayPanel1.Location = new System.Drawing.Point(4, 0);
            this.patientSpecimenDisplayPanel1.Name = "patientSpecimenDisplayPanel1";
            this.patientSpecimenDisplayPanel1.Patient = null;
            this.patientSpecimenDisplayPanel1.PatientID = "";
            this.patientSpecimenDisplayPanel1.PatientName = "";
            this.patientSpecimenDisplayPanel1.Size = new System.Drawing.Size(644, 68);
            this.patientSpecimenDisplayPanel1.Specimen = null;
            this.patientSpecimenDisplayPanel1.SpecimenID = "";
            this.patientSpecimenDisplayPanel1.TabIndex = 0;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Location = new System.Drawing.Point(4, 64);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 331);
            this.grpImage.TabIndex = 1;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(32, 32);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // FrmOrderSpecimenReflex
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(652, 456);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.pnlSelectSpecimen);
            this.Controls.Add(this.pnlOrderReflex);
            this.hlphelpChm.SetHelpKeyword(this, "Order_Reflex_Tests.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(650, 456);
            this.Name = "FrmOrderSpecimenReflex";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Order Reflex Test(s)";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmOrderSpecimenReflex_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.pnlOrderReflex, 0);
            this.Controls.SetChildIndex(this.pnlSelectSpecimen, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlSelectSpecimen.ResumeLayout(false);
            this.pnlOrderReflex.ResumeLayout(false);
            this.pnlReflexUnits.ResumeLayout(false);
            this.grpReflex.ResumeLayout(false);
            this.grpUnits.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Events/Event Handlers

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/10/2003</CreationDate>
		///
		/// <summary>
		/// Cancel button click event handler, closes the form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}
		
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/17/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, process the request
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			
			//If pnlOrderReflex is visible, save the data
			if (this.pnlOrderReflex.Visible)
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave(FORM_NAME)) == DialogResult.Yes)
				{				
					if (CheckExpiration())
					{
						SaveReflexTests();						
						return;
					}
				}
			}
			else //Patient Speciment Search is visible, switch to pnlOrderReflex panel
			{
				this._specimen = new BOL.Specimen(this.patientOrderSelector1.PatientSpecimenGuid);
				//Check if selected test is in Complete status
				if (CheckOrderStatus())
				{
					this.PopulateOrderReflexPanel();
				}
			}
		}

		private void patientOrderSelector1_ItemSelected(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = true;
		}

		private void patientOrderSelector1_ItemDeselected(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = false;
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			
			//this.pnlSelectSpecimen.ContainsFocus()	
			//Show tool tip depending what panel is visible. Only available on disabled button
			if (this.btnOK.EnabledButton == false && this.pnlOrderReflex.Visible == true)
			{
				this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.UC045.EnableOKOrderPanel().ResString);
			}
			if (this.btnOK.EnabledButton == false && this.pnlSelectSpecimen.Visible == true)
			{
				this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.UC045.EnableOKSearchPanel().ResString);
			}
		}
		
		/// <summary>
		/// Enables and disables the OK button based on the items checked
		/// </summary>
		private void lvReflexTests_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{

			int ItemsCheckedCount = this.lvReflexTests.CheckedItems.Count;
			
			if (e.NewValue == CheckState.Checked)
			{
				//BR_98.02
				int orderableTestId = (int) lvReflexTests.Items[e.Index].Tag;
				if (this._specimen.Patient.AboRh.RH == Common.RH.Positive && 
					(orderableTestId == (int) Common.OrderableTest.AGwD || 
					orderableTestId == (int) Common.OrderableTest.RepeatAGwD)) 
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC045.BR12WeakDTestRHPositivePatient());
					e.NewValue = CheckState.Unchecked;
				}
				else
				{
					ItemsCheckedCount = this.lvReflexTests.CheckedItems.Count + 1;
				}
			}
			else if (e.NewValue == CheckState.Unchecked)
			{
				ItemsCheckedCount = this.lvReflexTests.CheckedItems.Count - 1;
			}

			//Disable or enable the OK button
			if (ItemsCheckedCount == 0)
			{
				this.btnOK.EnabledButton = false;
				this.IsDirty = false;
			}
			else if (this._unitsVisible == true && this.lvCrossmatchUnits.CheckedItems.Count == 0)
			{
				//If Units for Repeat Crossmatch list is visible, at least one must be checked
				this.btnOK.EnabledButton = false;
				this.IsDirty = false;
			}
			else
			{
				this.btnOK.EnabledButton = true;
				this.IsDirty=true;
			}
		}

		/// <summary>
		/// Enables and disables the OK button based on the items checked
		/// </summary>
		private void lvCrossmatchUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
		
			int ItemsCheckedCount = this.lvCrossmatchUnits.CheckedItems.Count;

			if (e.NewValue == CheckState.Checked)
			{
				ItemsCheckedCount = this.lvCrossmatchUnits.CheckedItems.Count + 1;
			}
			else if (e.NewValue == CheckState.Unchecked)
			{
				ItemsCheckedCount = this.lvCrossmatchUnits.CheckedItems.Count - 1;
			}
			
			if (ItemsCheckedCount == 0 || this.lvReflexTests.CheckedItems.Count == 0)
			{
				this.btnOK.EnabledButton = false;
			}
			else
			{
				this.btnOK.EnabledButton = true;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmOrderSpecimenReflex_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				this.btnOK_MouseHover(this, EventArgs.Empty);
				textToSpeak = this.ttToolTip.GetToolTip(this.btnOK);
			}
			if(this.patientOrderSelector1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientOrderSelector1.GetErrorMessagesFor508());
			}
			if(this.patientSpecimenDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientSpecimenDisplayPanel1.GetErrorMessagesFor508());
			}
			this.SpeakMessage( textToSpeak );		
		}		
		
		#endregion

		#region Methods

		/// <summary>
		/// Display patient/specimen information
		/// </summary>
		private void PopulateOrderReflexPanel()
		{
			//Display the panel
			this.pnlOrderReflex.BringToFront();

			//populate the Patient/Specimen info
			this.patientSpecimenDisplayPanel1.Specimen = _specimen;
			
	
			//Selected test is Crossmatch
			if ((this._orderableTestID == (int)Common.OrderableTest.XM) || 
				(this._orderableTestID == (int)Common.OrderableTest.RepeatXM))
			{
				if (this.CheckCrossmatchPhlebotomistAndExpiration() == true)
				{
					//populate the list of available test
					this.PopulateReflexTestsList();

					//populate the list of repeat crossmatched units
					this.PopulateRepeatCrossmatchUnitsList();
					this._unitsVisible = true;
					ShowHideRepeatCrossmatchUnits();
				}
				else
				{
					//clear exisiting list
					this.lvReflexTests.Items.Clear();
					ListViewItem lvItem = new ListViewItem("No records found");
					this.lvReflexTests.Items.Add(lvItem);
					this.lvReflexTests.CheckBoxes = false;
					controls.VbecsFunction.SetColumnWidths(this.lvReflexTests);
				}
				
			}
			else
			{
				//populate the list of available test
				this.PopulateReflexTestsList();
			}

			//Set Panels visibility property
			this.pnlSelectSpecimen.Visible = false;
			this.pnlOrderReflex.Visible = true;

			//Disabled until a reflex order type has been selected
			this.btnOK.EnabledButton = false;

		}

		/// <summary>
		/// Populate orderable reflex tests list with all reflex tests 
		/// </summary>
		private void PopulateReflexTestsList()
		{
			this._dtTestList = BOL.OrderedTest.GetReorderableTestList(this._orderableTestID);

			//clear exisiting list
			this.lvReflexTests.Items.Clear();

			if (_dtTestList.Rows.Count == 0)
			{
				ListViewItem lvItem = new ListViewItem("No records found");
				this.lvReflexTests.Items.Add(lvItem);
				this.lvReflexTests.CheckBoxes = false;
			}
			else
			{
				this.lvReflexTests.CheckBoxes = true;
				foreach(DataRow drReflexTest in _dtTestList.Rows)
				{
					ListViewItem lvItem = new ListViewItem();
					if (drReflexTest.IsNull(Common.VbecsTables.OrderableTest.OrderableTestName) == false)
						lvItem.SubItems.Add(drReflexTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");
					if (drReflexTest.IsNull(Common.VbecsTables.OrderableTest.OrderableTestText) == false)
						lvItem.SubItems.Add(drReflexTest[Common.VbecsTables.OrderableTest.OrderableTestText].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					lvItem.Tag = drReflexTest[Common.VbecsTables.OrderableTest.OrderableTestId];

					this.lvReflexTests.Items.Add(lvItem);
				}
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvReflexTests);
		}
	
		/// <summary>
		/// Populate Units for Repeat Crossmatch list
		/// </summary>
		private void PopulateRepeatCrossmatchUnitsList()
		{
			this._dtRepeatXMUnitList = BOL.OrderedUnit.GetOrderedUnitsForRepeatXM(this._orderedTestGUID, this._orderedComponentGUID);
			//clear exisiting list
			this.lvCrossmatchUnits.Items.Clear();

			if (_dtRepeatXMUnitList.Rows.Count == 0)
			{
				ListViewItem lvItem = new ListViewItem("No records found");
				this.lvCrossmatchUnits.Items.Add(lvItem);
				this.lvCrossmatchUnits.CheckBoxes = false;
			}
			else
			{
				this.lvCrossmatchUnits.CheckBoxes = true;
				foreach(DataRow drRepeatXMUnit in _dtRepeatXMUnitList.Rows)
				{
					if (drRepeatXMUnit.IsNull(Common.VbecsTables.OrderedUnit.CrossmatchResultCode) == true)
						continue;

					ListViewItem lvItem = new ListViewItem();
					if (drRepeatXMUnit.IsNull(Common.VbecsTables.BloodUnit.EyeReadableUnitId) == false)
						lvItem.SubItems.Add(drRepeatXMUnit[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");
					if (drRepeatXMUnit.IsNull(Common.VbecsTables.BloodProduct.ProductShortName) == false)
						lvItem.SubItems.Add(drRepeatXMUnit[Common.VbecsTables.BloodProduct.ProductShortName].ToString().Trim() + ", "+
							BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(drRepeatXMUnit[Common.VbecsTables.BloodUnit.LabelTypeCode]),drRepeatXMUnit[Common.VbecsTables.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(drRepeatXMUnit[Common.VbecsTables.DonationType.DonationTypeCode].ToString()),drRepeatXMUnit[Common.VbecsTables.BloodUnit.UnitDivisionId].ToString()));
					else
						lvItem.SubItems.Add(" ");
					if ((drRepeatXMUnit.IsNull(Common.VbecsTables.BloodUnitMedia.BloodTypeCode) == false) && 
						(drRepeatXMUnit.IsNull(Common.VbecsTables.BloodUnitMedia.RhFactorCode) == false))
						lvItem.SubItems.Add(drRepeatXMUnit[Common.VbecsTables.BloodUnitMedia.BloodTypeCode].ToString().Trim() + " " + drRepeatXMUnit[Common.VbecsTables.RhFactor.RhFactorText].ToString() + " ");
					else
						lvItem.SubItems.Add(" ");
					if (drRepeatXMUnit.IsNull(Common.VbecsTables.BloodUnitMedia.UnitExpirationDate) == false)
						lvItem.SubItems.Add(drRepeatXMUnit[Common.VbecsTables.BloodUnitMedia.UnitExpirationDate].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					lvItem.Tag = drRepeatXMUnit;

					this.lvCrossmatchUnits.Items.Add(lvItem);
				}
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvCrossmatchUnits);
	    }

		/// <summary>
		/// Checks if the selected specimen is not expired 
		/// Displaying BR_45.04, implementation is part of Specimen BOL
		/// </summary>
		private bool CheckExpiration()
		{
			try
			{	
				if ((this._specimen.IsExpired) && (this._specimen.IsNew == false))//Specimen is expired and has been previously saved
				{
					DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.MakeAvailableExpiredorUnacceptableSpecimen());
				
					if (result == DialogResult.Yes)  //Make expired or unacceptable specimen available
					{
						if(this.LoadExtensionScreen() == true)
						{
							return true;
						}
						else
						{
							//Expired specimen comment is not entered
							return false;
						}
					}
					else  //Don't make expired or unacceptable specimen available
					{
						return false;
					}
					
				}
				return true;
			}

			catch (BOL.BusinessObjectException ex)
			{	
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
				return false;
			}		
		}

		private bool LoadExtensionScreen()
		{
			DlgOverrideComment reflexOverride = new DlgOverrideComment("Expired Specimen","Selected specimen is expired. Enter a comment to continue","PT");
            reflexOverride.ShowDialogFromLockedParent(this, false);
            
            if (reflexOverride.DialogResult == DialogResult.OK)
			{
				//Add/update comment
				_expiredSpecimenComment = reflexOverride.Comment;
				reflexOverride.Close();				
				return true;
			}
			else
			{
				//user canceled the Expired Specimen comment window and we will now save test
				reflexOverride.Close();
				return false;
			}
		}
	
		/// <summary>
		/// Display or hide Select Unit for Repeat Crossmatch list, resize Order Reflex Test list
		/// </summary>
		private void ShowHideRepeatCrossmatchUnits()
		{
			if(this._unitsVisible)
			{
				this.grpUnits.Visible = true;
				this.grpReflex.Size = new System.Drawing.Size(604, 208);
			}
			else
			{
				this.grpUnits.Visible = false;
				this.grpReflex.Size = new System.Drawing.Size(604, 328);
			}
		}
		
		/// <summary>
		/// Saves form data: adds reflex tests to Pending Task List (PLT), saves 
		/// specimen override and repeat crossmatch units if available
		/// </summary>
		private void SaveReflexTests()
		{
			bool savedResults;
			int counter = 0;

			//Get List of all selected tests
			int[] selectedTests = new int[this.lvReflexTests.CheckedItems.Count];
			
			foreach(ListViewItem lvItem in this.lvReflexTests.CheckedItems)
			{
				selectedTests[counter] = (int) lvItem.Tag;
				++counter;
			}

			DataTable dtSelectedUnits = new DataTable();
			if (this._unitsVisible == true)
			{
				dtSelectedUnits = this._dtRepeatXMUnitList.Clone();

				foreach(ListViewItem lvItem in this.lvCrossmatchUnits.CheckedItems)
				{
					DataRow drSelectedUnit = dtSelectedUnits.NewRow();
					drSelectedUnit.ItemArray = ((DataRow) lvItem.Tag).ItemArray;
					dtSelectedUnits.Rows.Add(drSelectedUnit);
				}

			}
			savedResults = BOL.OrderedTest.SaveReflexTests(
							selectedTests, 
							dtSelectedUnits,
							this._specimen,
							this._patientTreatmentGUID,
							this._orderedTestGUID,
							this._orderedComponentGUID,
							this._expiredSpecimenComment,
							Common.UpdateFunction.UC045_FrmOrderSpecimenReflex);

			if (savedResults)
			{
				this.IsDirty=false;
				this.Close();
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved(FORM_NAME));
			}
		}

		/// <summary>
		/// Checks if the specimen is associated with more than one physician order. 
		/// Allowes to select the physician order to which the reflex test is associated. 
		/// BR_45.11
		/// </summary>
		private bool CheckOrderStatus()
		{	
			if ((this.patientOrderSelector1.OrderStatusCode == Common.OrderStatus.Complete &&
				 this.patientOrderSelector1.OrderedTestGuid.Equals(DBNull.Value) != true &&
				 this.patientOrderSelector1.OrderedTestGuid.Equals(Guid.Empty) != true) ||
				(this.patientOrderSelector1.OrderedComponentGuid.Equals(DBNull.Value) != true &&
				this.patientOrderSelector1.OrderedComponentGuid.Equals(Guid.Empty) != true))
			{
				//get the parent Ordered Test GUID or parent Ordered Component GUID
				//parent order Patient Treatment GUID, and Orderable Test ID
				this._orderedTestGUID = this.patientOrderSelector1.OrderedTestGuid;
				this._orderedComponentGUID = this.patientOrderSelector1.OrderedComponentGuid;
				this._patientTreatmentGUID = this.patientOrderSelector1.PatientTreatmentGuid;
				this._orderableTestID = this.patientOrderSelector1.OrderableTestId;

				//get the Patient Specimen GUID
				this._patientSpecimenGUID = this.patientOrderSelector1.PatientSpecimenGuid;
				return true;
			}
			else
			{
				//Show message to the user
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC045.NoCompleteTestsExist());
				return false;
			}
			
		}

		/// <summary>
		/// Displayed when coming from UC_56 and more than one order was selected by the user.
		/// Allowes to select the physician order to which the reflex test is associated. 
		/// </summary>
		private bool DisplayMultipleOrders()
		{	
			bool oneParentOrder = false;

			DlgSelectOrder selectOrder = new DlgSelectOrder(this._orderedTestsList, this._orderedComponentsList, ref oneParentOrder);
			
			if (oneParentOrder == false)
			{
				selectOrder.ShowDialogFromLockedParent(this,false);
			}
			
			DialogResult result = selectOrder.DialogResult;

			if (result == DialogResult.OK)
			{
				//get the parent Ordered Test GUID or parent Ordered Component GUID 
				this._orderedTestGUID = selectOrder.OrderedTestGuid;
				this._orderedComponentGUID = selectOrder.OrderedComponentGuid;
				this._patientTreatmentGUID = selectOrder.PatientTreatmentGuid;

				//get the Orderable Test ID
				this._orderableTestID = selectOrder.OrderableTestId;

				//get the Patient Specimen GUID
				this._patientSpecimenGUID = selectOrder.PatientSpecimenGuid;

				selectOrder.Close();
				return true;
			}
			else
			{
				selectOrder.Close();
				return false;
			}
		}
		
		/// <summary>
		/// Displaing BR_45.10 A crossmatch test and a repeat crossmatch test cannot be ordered unless 
		/// it is associated with a specimen with a future expiration date and a phlebotomist 
		/// is associated with that specimen.
		/// </summary>
		/// <returns>True or False</returns>
		private bool CheckCrossmatchPhlebotomistAndExpiration()
		{
			try
			{	
				if ((this._specimen.IsExpired && this._specimen.IsNew == false) 
					|| (this._specimen.Phlebotomist != String.Empty))
				{
					return true;
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC045.BR10CrossmatchTestsAndSpecimen());
					return false;
				}

			}

			catch (BOL.BusinessObjectException ex)
			{	
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
				return false;
			}				
		}

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.vbecsLogo1.Title = FORM_NAME;
		}

		#endregion

		private void lvReflexTests_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvReflexTests);
		}

		private void lvCrossmatchUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvCrossmatchUnits);
		}



		#region Properties
		//properties are used instead of public or protected variables

		#endregion


	}
}

